#!/bin/sh

# Use to clean all the logs,audits and their respective zip file.

# Type of request: delete all or expired files.
request_type=$1

# A Time that is more or less x minutes from the current time.
ten_min_ago=$((`date +%s`-600))
ten_min_fwd=$((`date +%s`+600))

# Delete audit and log compress files that are expired.
if [ "$request_type" = "delete_expired" ]; then

    # Make a list with all the log compressed files.
    log_zip_list=$(find /tmp/zip/logs/ -name "*.zip")

    # Remove all the log compressed files that are expired.
    for file in $log_zip_list ; do

        file_date=$(stat -c %Y $file)

        if [ $file_date -lt $ten_min_ago ] || [ $file_date -gt $ten_min_fwd ]; then
            rm $file
        fi

    done

    # Make a list with all the audit compressed files.
    audit_zip_list=$(find /tmp/zip/audits/ -name "*.zip")

    # Remove all the audit compressed files that expired.
    for file in $audit_zip_list ; do

        file_date=$(stat -c %Y $file)

        if [ $file_date -lt $ten_min_ago ] || [ $file_date -gt $ten_min_fwd ]; then
            rm $file
        fi

    done

# Delete all log files, dmesg files, compressed audit files and compressed log files.
elif [ "$request_type" = "delete_all" ]; then

    # Delete log compressed files.
    rm -f /tmp/zip/logs/*.zip

    # Delete audit compressed files.
    rm -f /tmp/zip/audits/*.zip

    # Delete temporary log files.
    rm -rf /tmp/logs/*

    # Delete permanent log files.
    rm -rf /rw/logs/*

    # Delete saved log files.
    rm -rf /rw/savedlogs/*

    # Delete all coredumps (delete the directory: it is automatically created by systemd upon dumping a core).
    rm -rf /rw/coredumps
else
    exit 1
fi

exit 0

